#!/bin/bash

# Install and setup script for Ships-Bells

# Release 0.9.2 2013/11/09 Copyright Renaud Olgiati
# renaud@olgiati-in-paraguay.org

# Check install as user and not as root.
if [ `id -u` -eq 0 ]; then
	echo "-------------------------------------------------------------------"
	echo "You are trying to install Ships-Bells as root !"
	echo "Installing as root causes problems while running so I am getting out now."
	echo "-------------------------------------------------------------------"
	exit 1
fi
# Check if cron is running.
ps aux -A | grep cron | grep -v grep > crontmp
if [ -s crontemp ]; then
	echo "-------------------------------------------------------------------"
	echo "Cron is not running, so Ship-Bells cannot run. If you are running Android,"
	echo "see http://stackoverflow.com/questions/16747880/how-to-use-crontab-in-android"
	echo "for information on how to run cron on your device."
	echo "-------------------------------------------------------------------"
	exit 1
fi
# Check Alsa-utils is installed
if [ ! -f /usr/bin/aplay ]; then
	echo "-------------------------------------------------------------------"
	echo "Alsa-utils is not installed on this computer !"
	echo "Please install it, and run the script again."
	echo "-------------------------------------------------------------------"
	exit 1
fi
# If needed create the directory and copy the files, else offer to uninstall
if [ ! -f ~/Music/shipbells/strikebells ]; then
	echo "-------------------------------------------------------------------"
	echo "The running directory does not exist."
	echo "Creating directory and copying files."
	echo " "
	mkdir -p ~/Music/shipbells
	cp * ~/Music/shipbells/
	echo "Files copied."
	cd ..
	rm -fr shipbellstmp
	echo "Temporary directory removed."
	cd ~/Music/shipbells
fi
# If strikebells lines present in crontab, offer to uninstall
crontab -l | grep -v strikebells > crontemp
if [ ! -s crontemp ]; then
	echo "-------------------------------------------------------------------"
	echo "There are strikebells lines in crontab."
	read -p "Do you want to un-install Ship-Bells ? (y/N)" KSU
	if [ "$KSU" = "Y" -o "$KSU" = "y" ]; then
		echo "-------------------------------------------------------------------"
		echo "Removing strikebells lines from crontab"
		crontab -l | grep -v strikebells > crontemp
		crontab crontemp
		rm -f crontemp
		cd ~/Music
		echo "-------------------------------------------------------------------"
		echo "The script will now exit; You may then completely purge all files with:"
		echo " $ rm -fr shipbells"
		exit 1
	fi
rm -f crontemp
fi

# Script body: Install
echo "-------------------------------------------------------------------"
echo "The program can strike bells in the UK Royal Navy style (Second dog-watch struck 1, 2, 3, 8)"
echo " or US Navy style (Second dog-watch struck 5, 6, 7, 8)."
echo ""
echo "Do you want to install UK style [K] or US style [S] ?"
echo " "
while true; do
	read -p "Please answer K, S, or Ctrl-C to exit : " KSU
	case $KSU in
	[Kk]* )
	echo "-------------------------------------------------------------------"
	echo "Installing strikebells lines, Royak Navy style, in crontab"
	echo "-------------------------------------------------------------------"
	crontab -l | grep -v strikebells > crontemp
	echo "# runs strikebells according to the Royal Navy (post-Nore Mutiny) pattern." >> crontemp
	echo "30 0,4,8,12,16,18,20 * * * ~/Music/shipbells/strikebells 1" >> crontemp
	echo "0 1,5,9,13,17,19,21 * * * ~/Music/shipbells/strikebells 2" >> crontemp
	echo "30 1,5,9,13,17,19,21 * * * ~/Music/shipbells/strikebells 3" >> crontemp
	echo "0 2,6,10,14,18,22 * * * ~/Music/shipbells/strikebells 4" >> crontemp
	echo "30 2,6,10,14,22 * * * ~/Music/shipbells/strikebells 5" >> crontemp
	echo "0 3,7,11,15,23 * * * ~/Music/shipbells/strikebells 6" >> crontemp
	echo "30 3,7,11,15,23 * * * ~/Music/shipbells/strikebells 7" >> crontemp
	echo "0 0,4,8,12,16,20 * * * ~/Music/shipbells/strikebells 8" >> crontemp
	crontab crontemp
	rm -f crontemp
	break
	;;
	[Ss]* ) 
	echo "-------------------------------------------------------------------"
	echo "Installing strikebells lines, US Navy style, in crontab"
	echo "-------------------------------------------------------------------"
	crontab -l | grep -v strikebells > crontemp
	echo "# runs strikebells according to the US Navy pattern." >> crontemp
	echo "30 0,4,8,12,16,20 * * * ~/Music/shipbells/strikebells 1" >> crontemp
	echo "0 1,5,9,13,17,21 * * * ~/Music/shipbells/strikebells 2" >> crontemp
	echo "30 1,5,9,13,17,21 * * * ~/Music/shipbells/strikebells 3" >> crontemp
	echo "0 2,6,10,14,18,22 * * * ~/Music/shipbells/strikebells 4" >> crontemp
	echo "30 2,6,10,14,18,22 * * * ~/Music/shipbells/strikebells 5" >> crontemp
	echo "0 3,7,11,15,19,23 * * * ~/Music/shipbells/strikebells 6" >> crontemp
	echo "30 3,7,11,15,19,23 * * * ~/Music/shipbells/strikebells 7" >> crontemp
	echo "0 0,4,8,12,16,20 * * * ~/Music/shipbells/strikebells 8" >> crontemp
	crontab crontemp
	rm -f crontemp
	break
	;;
	* ) 
	;;
	esac
done

# Setting the bells volume
cd ~/Music/shipbells
echo -n "The present volume setting is :"
VOL=`gawk '/Master/{ print $5 }' strikebells`
echo $VOL
./strikebells 4
while true; do
read -p "Is the volume correct ? (Y/n) : " I1
case $I1 in
N|n*)
	while true; do
	echo "-------------------------------------------------------------------"
	read -p "Enter the new volume setting (between 00 and 99) : " KSU
	case $KSU in
	[0-9][0-9]*)
	break
	;;
	*)
	echo "	Bad value"
	;;
	esac
	done
	sed "/Master/s/[0-9][0-9]/$KSU/" ~/Music/shipbells/strikebells > crontemp
	cp -f crontemp ~/Music/shipbells/strikebells
	rm -f crontemp
	echo -n "The new volume setting is : "
	VOL=`gawk '/Master/{ print $5 }' strikebells`
	echo $VOL
	./strikebells 4
	echo "-------------------------------------------------------------------"
;;
*)
;;
break
esac
done
	echo "Finished, enjoy !"
	echo "-------------------------------------------------------------------"
exit 0
	




